<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage config
* @filesource
*//** */

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

//set default controller differently if using the admin panel domain
if(defined('API_ADMINPANEL_DOMAIN') && strstr($_SERVER['HTTP_HOST'], API_ADMINPANEL_DOMAIN)) {
	$route['default_controller'] = 'admin/applications';
}
else { $route['default_controller'] = 'admin/direct'; }
$route['404_override'] = '';

/* Admin Panel Routes */
/* onboarding routes */
$route['onboarding/request'] = 'admin/onboarding/onboarding_request/';
$route['onboarding/request/edit/(:any)'] = 'admin/onboarding/onboarding_request_edit/$1';

/* applications routes */
$route['applications/list'] = 'admin/applications/application_list/';
$route['applications/edit/(:any)'] = 'admin/applications/application_edit/$1';

/* facilities routes */
$route['facilities/list'] = 'admin/facilities/facility_list/';
$route['facilities/edit/(:any)'] = 'admin/facilities/facility_edit/$1';

/* reports routes */
$route['reports/requests'] = 'admin/reports/report_requests/';
$route['reports/events'] = 'admin/reports/report_events/';
$route['reports/logins'] = 'admin/reports/report_logins/';
$route['reports/mail'] = 'admin/reports/report_mail/';
$route['reports/tickets'] = 'admin/reports/report_tickets/';
$route['reports/facility'] = 'admin/reports/report_facility/';
$route['reports/hisp'] = 'admin/reports/report_hisp/';
$route['reports/points_of_origin'] = 'admin/reports/report_points_of_origin/';
$route['reports/user_activity_summary'] = 'admin/reports/report_user_activity_summary/';

/* user settings routes */
$route['user_settings/application_list'] = 'admin/user_settings/application_list/';
$route['user_settings/webservice_access_edit'] = 'admin/user_settings/webservice_access_edit/';
$route['user_settings/account_edit'] = 'admin/user_settings/account_edit/';

/* global search routes */
$route['global_search'] = 'admin/global_search_controller/index';
$route['global_search/search'] = 'admin/global_search_controller/search/';
$route['global_search/view/(:num)'] = 'admin/global_search_controller/view/$1';
$route['global_search/raw/(:num)'] = 'admin/global_search_controller/raw/$1';
$route['global_search/update_folders/(:any)'] = 'admin/global_search_controller/update_folders/$1';
$route['global_search/get_attachment/(:num)/(:any)'] = 'admin/global_search_controller/get_attachment/$1/$2';

/* admin routes */
$route['administration/manage/accounts'] = 'admin/administration/admin_manage_accounts/';
$route['administration/manage/accounts/edit/access/(:any)'] = 'admin/administration/admin_edit_account_access/$1';
$route['administration/manage/accounts/edit/(:any)'] = 'admin/administration/admin_edit_account/$1';
$route['administration/manage/accounts/disable'] = 'admin/administration/disable_account/';
$route['administration/manage/accounts/enable'] = 'admin/administration/enable_account/';
$route['administration/application/requests'] = 'admin/administration/admin_request_list/';
$route['administration/account/requests'] = 'admin/administration/account_request_list/';
$route['administration/manage/groups'] = 'admin/administration/admin_manage_groups/';
$route['administration/manage/groups/edit/access/(:any)'] = 'admin/administration/admin_edit_group_access/$1';
$route['administration/manage/groups/edit/(:any)'] = 'admin/administration/admin_edit_group/$1';
$route['administration/manage/groups/disable'] = 'admin/administration/disable_group/';
$route['administration/manage/groups/enable'] = 'admin/administration/enable_group/';
$route['administration/manage_groups/application_list/(:any)'] = 'admin/user_settings/application_list/$1';
$route['administration/manage/facilities'] = 'admin/administration/admin_manage_facilities/';
$route['administration/manage/facilities/edit'] = 'admin/administration/facility_edit';
$route['administration/manage/facilities/edit/(:any)'] = 'admin/administration/facility_edit/$1';

/* ------------------- */

/* Admin API routes */
$route['admin/create/user'] = 'services/admin/create_user/';
$route['admin/create/group'] = 'services/admin/create_group/';

/* ------------------- */

/*Re-route sub-directories for controllers to top-level */
/* admin pages */
$route['onboarding'] = 'admin/onboarding';
$route['onboarding/(:any)'] = 'admin/onboarding/$1';
$route['applications'] = 'admin/applications';
$route['applications/(:any)'] = 'admin/applications/$1';
$route['facilities'] = 'admin/facilities';
$route['facilities/(:any)'] = 'admin/facilities/$1';
$route['reports'] = 'admin/reports';
$route['reports/(:any)'] = 'admin/reports/$1';
$route['administration'] = 'admin/administration';
$route['administration/(:any)'] = 'admin/administration/$1';
$route['user_settings'] = 'admin/user_settings';
$route['user_settings/(:any)'] = 'admin/user_settings/$1';
$route['support'] = 'admin/support';
$route['support/(:any)'] = 'admin/support/$1';

/* API SERVICES  */

/* accounts */
$route['direct/account/update/(:any)'] = 'services/account_controller/update_account/$1';
$route['direct/account/update'] = 'services/account_controller/update_account';
$route['direct/account/in_facility/(:any)'] = 'services/account_controller/accounts_in_facility/$1';
$route['direct/account/in_facility'] = 'services/account_controller/accounts_in_facility';
$route['direct/account/(:any)'] = 'services/account_controller/account/$1';
$route['direct/account'] = 'services/account_controller/account';

/* groups*/

$route['direct/group/update/(:any)'] = 'services/group_controller/update_group/$1';
$route['direct/group/update'] = 'services/group_controller/update_group';
$route['direct/group/in_facility/(:any)'] = 'services/group_controller/groups_in_facility/$1';
$route['direct/group/in_facility'] = 'services/group_controller/groups_in_facility';
$route['direct/group/(:any)'] = 'services/group_controller/group/$1';
$route['direct/group'] = 'services/group_controller/group';


/* folders */
$route['direct/folders/archive/(:any)'] = 'services/folder_controller/archive_folder/$1';
$route['direct/folders/archive'] = 'services/folder_controller/archive_folder';
$route['direct/folders/rename/(:any)'] = 'services/folder_controller/rename_folder/$1';
$route['direct/folders/rename'] = 'services/folder_controller/rename_folder';
$route['direct/folders/create/(:any)'] = 'services/folder_controller/create_folder/$1';
$route['direct/folders/create'] = 'services/folder_controller/create_folder';
$route['direct/folders/(:any)'] = 'services/folder_controller/folders/$1';
$route['direct/folders'] = 'services/folder_controller/folders';

/* message save/send */
$route['direct/messages/save/(:any)'] = 'services/message_send_controller/save/$1';
$route['direct/messages/save'] = 'services/message_send_controller/save';
$route['direct/messages/send/draft/(:any)'] = 'services/message_send_controller/send_draft/$1';
$route['direct/messages/send/draft'] = 'services/message_send_controller/send_draft';
$route['direct/send/(:any)'] = 'services/message_send_controller/send/$1';
$route['direct/send'] = 'services/message_send_controller/send';
$route['direct/save/(:any)'] = 'services/message_send_controller/save/$1';
$route['direct/save'] = 'services/message_save_controller/send';

/* message management */
$route['direct/messages/move/(:any)'] = 'services/message_controller/move_message/$1';
$route['direct/messages/move'] = 'services/message_controller/move_message';
$route['direct/messages/archive/(:any)'] = 'services/message_controller/archive_message/$1';
$route['direct/messages/archive'] = 'services/message_controller/archive_message';
$route['direct/messages/restore/(:any)'] = 'services/message_controller/restore_message/$1';
$route['direct/messages/restore'] = 'services/message_controller/restore_message';
$route['direct/messages/flag/set/(:any)'] = 'services/message_controller/set_flag/$1';
$route['direct/messages/flag/set'] = 'services/message_controller/set_flag';

/* message retrieve */
$route['direct/messages/count/(:any)'] = 'services/message_retrieve_controller/count/$1';
$route['direct/messages/count'] = 'services/message_retrieve_controller/count';
$route['direct/messages/(:any)'] = 'services/message_retrieve_controller/messages/$1';
$route['direct/messages'] = 'services/message_retrieve_controller/messages';
$route['direct/message/(:any)'] = 'services/message_retrieve_controller/message/$1';
$route['direct/message'] = 'services/message_retrieve_controller/message';

/* reports */
$route['direct/reports/get_mailbox_activities/(:any)'] = 'services/reports/get_mailbox_activities/$1';
$route['direct/reports/get_mailbox_activities'] = 'services/reports/get_mailbox_activities';

/* validation */
$route['direct/validate/(:any)'] = 'services/direct/validate/$1';
$route['direct/validate'] = 'services/direct/validate';

$route['direct/(:any)'] = 'services/direct/$1';
$route['direct'] = 'services/direct';

$route['admin/(:any)'] = 'services/admin/$1';
$route['admin'] = 'services/admin';


/* tests */
$route['tests/(provider_directory|direct|admin|retrieve|send|folder|message|report|search)'] = 'tests/$1_tests/index';
$route['tests/(provider_directory|direct|admin|retrieve|send|folder|message|report|search)/(:any)'] = 'tests/$1_tests/test/$2';
/* ------------------- */

/* End of file routes.php */
/* Location: ./application/config/routes.php */